unit Trepform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Rebdlg, Verdlg, ExtCtrls, DB, DBTables,
  DBGrids, DBIErrs, Tu, Buttons, Gauges;

type
  TListFocus = (LBSelectFrom, LBMissing, LBNone);

type
  TRepairForm = class(TForm)
    Bevel1: TBevel;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    TUtilityVerReb: TTUtility;
    ListBoxStatus: TListBox;
    SaveDialogActivityLog: TSaveDialog;
    ListBoxMissing: TListBox;
    SelectFromLB: TListBox;
    ComboBoxTblAlias: TComboBox;
    ComboBoxBorrowAlias: TComboBox;
    TableErrTable: TTable;
    DataSource1: TDataSource;
    GroupBoxVerify: TGroupBox;
    GaugeIndex: TGauge;
    GaugeHeader: TGauge;
    GaugeData: TGauge;
    LabelZeroOf: TLabel;
    LabelOfZero: TLabel;
    GaugeHeaderIdx: TGauge;
    GaugeIndexIdx: TGauge;
    GaugeDataIdx: TGauge;
    GaugeIntegrity: TGauge;
    GroupBoxRebuild: TGroupBox;
    LabelNumPacked: TLabel;
    GaugeRebuild: TGauge;
    LabelRecSize: TLabel;
    LabelNumFields: TLabel;
    LabelNumRecs: TLabel;
    LabelPasswordTF: TLabel;
    LabelNumAuxPasswords: TLabel;
    LabelTableOf: TLabel;
    LabelOfTable: TLabel;
    SpeedButtonAll: TSpeedButton;
    SpeedButtonAllNone: TSpeedButton;
    CheckBoxAltStructOnly: TCheckBox;
    ButtonClose: TButton;
    ButtonVerifyOnly: TButton;
    ButtonViewErrTable: TButton;
    ButtonFixAll: TButton;
    butRebuild: TButton;
    ButtonSaveLog: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ButtonFixAllClick(Sender: TObject);
    procedure TUtilityVerRebInfoRebuild(Sender: TObject;
      RebuildCBRec: TRebuildCBData);
    procedure TUtilityVerRebInfoVerify(Sender: TObject;
      VerifyCBRec: TVerifyCBData);
    procedure TUtilityRestInfoVerReb(Sender: TObject; AMessage: String;
      Process: TUVerRebProcess; var Abort: Boolean);
    procedure ButtonCloseClick(Sender: TObject);
    procedure ButtonVerifyOnlyClick(Sender: TObject);
    procedure ButtonSaveLogClick(Sender: TObject);
    procedure ButtonViewErrTableClick(Sender: TObject);
    procedure ComboBoxBorrowAliasChange(Sender: TObject);
    procedure butRebuildClick(Sender: TObject);
    procedure ComboBoxTblAliasChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SelectFromLBClick(Sender: TObject);
    procedure ListBoxMissingClick(Sender: TObject);
    procedure SpeedButtonAllClick(Sender: TObject);
    procedure SpeedButtonAllNoneClick(Sender: TObject);
  private
    { Private declarations }
    CurProcess : TUVerRebProcess; {keep track of the rebuild or verify to eliminate screen flash}
    TablesProcessed : Word;
    fEditFilePattern : String;
    fListFocus : TListFocus;
    procedure ZeroGages;
    procedure AssignBatchRec(TU : TTUtility; sList : TStrings; I : Word);
    procedure SendToLog(aMsg : String);
    procedure UpdateStats(TU : TTUtility; BatchList : TStrings);
    procedure DeleteErrorTable;
    procedure ReFillSelectFromLB;
    function GetAliasPath(TheAlias : String) : String;
    procedure ReDoBorrowList;
    procedure SortList(aList : TStrings);
  public
    { Public declarations }
    AliasPath,
    AltPath : TFileName;
    fTblAlias : TFileName;
    fAltTblAlias : TFileName;
    procedure ChangeListFocus(FocusList : TListFocus);
  end;



var
  RepairForm: TRepairForm;

implementation

{$R *.DFM}


Procedure TRepairForm.ZeroGages;
begin
  GaugeHeader.Progress := 0;
  GaugeIndex.Progress := 0;
  GaugeData.Progress := 0;
  GaugeHeaderIdx.Progress := 0;
  GaugeIndexIdx.Progress := 0;
  GaugeDataIdx.Progress := 0;
  GaugeIntegrity.Progress := 0;
  GaugeRebuild.Progress := 0;
  LabelNumPacked.Caption := '';
  LabelNumPacked.refresh;
end;

Procedure TRepairForm.AssignBatchRec(TU : TTUtility;
                                  sList : TStrings;
                                      I : Word);
VAR
 s : string;
begin
  TU.TableName := '';
  TU.tBkUpTableName := '';
  TU.TableName      := AliasPath + '\' + sList.Strings[I];
  if fileexists(AltPath + '\' + sList.Strings[I]) then
  begin
    TU.AltStructAlways := True;
    TU.AltStructName  := AltPath + '\' + sList.Strings[I];
  end
  else
  begin
    TU.AltStructAlways := False;
    TU.AltStructName := '';
  end;
end;

Procedure TRepairForm.SendToLog(aMsg : String);
begin
  With ListBoxStatus do
  begin
    Items.Add(AMsg);
    { This next bit scrolls the text so the most recent msg is visible}
    if (ItemHeight * Items.count) > Height then
      TopIndex:= Items.count - (Height div ItemHeight) ;
  end;
  ListBoxStatus.Refresh;
end;


Procedure TRepairForm.UpdateStats(TU : TTUtility; BatchList : TStrings);
Begin
  If TU <> Nil then
  begin
    LabelNumRecs.Caption         := InttoStr(TU.TblInfo.iRecords);
    LabelRecSize.Caption         := IntToStr(TU.TblInfo.iRecSize);
    LabelNumFields.Caption       := IntToStr(TU.TblInfo.iFields);
    LabelNumAuxPasswords.Caption := IntToStr(TU.TblInfo.iPasswords);
    if TU.TblInfo.bProtected then
      LabelPasswordTF.Caption := 'True'
    else
      LabelPasswordTF.Caption := 'False';
    Inc(TablesProcessed);
    if BatchList <> nil then
    begin
      LabelTableOf.Caption := IntToStr(TablesProcessed);
      LabelOfTable.Caption := IntToStr(BatchList.Count);
    end
    else
    begin
      LabelTableOf.Caption := '';
      LabelOfTable.Caption := '';
    end;
  end
  else
  begin
    LabelNumRecs.Caption         := '0';
    LabelRecSize.Caption         := '0';
    LabelNumFields.Caption       := '0';
    LabelNumAuxPasswords.Caption := '';
    LabelPasswordTF.Caption := '';
    LabelTableOf.Caption := '';
    LabelOfTable.Caption := '';
  end;
  Panel1.Refresh;
end;

procedure TRepairForm.DeleteErrorTable;
Var
  ErrTblName : String[255];
begin
  { make sure the error table is not active }
  TableErrTable.Active := False;
  TableErrTable.DatabaseName := Session.PrivateDir;
  {Make sure the error table name has an extension }
  if extractFileExt(TableErrTable.TableName) = '' then
    ErrTblName := TableErrTable.TableName + '.DB'
  else
    ErrTblName := TableErrTable.TableName;
  {if the error table  does not have a path then assign the private one}
  if extractFilePath(TableErrTable.TableName) = '' then
    ErrTblName := Session.PrivateDir + '\' + ErrTblName;
  {Now delete the table if it exists}
  if fileexists(ErrTblName) then
    TableErrTable.DeleteTable;
end;

procedure TRepairForm.FormCreate(Sender: TObject);
begin
  {Set get Database names}
  fTblAlias := '';
  fAltTblAlias := '';
{***  ErrDlg := nil; }
  AliasPath := GetAliasPath(fTblAlias);
  AltPath   := GetAliasPath(fAltTblAlias);
  {Set Get table names}
  Session.GetDataBaseNames(ComboBoxTblAlias.Items);
  Session.GetDataBaseNames(ComboBoxBorrowAlias.Items);
  fEditFilePattern := '*.DB';
  Session.GetTableNames(fTblAlias, fEditFilePattern, True, False, SelectFromLB.Items);
  {Sort the list}
  SortList(SelectFromLB.Items);
  SelectFromLB.ItemIndex := -1;
  ChangeListFocus(LBNone);
end;

procedure TRepairForm.ButtonFixAllClick(Sender: TObject);
var
  aList : TStringList;
  I : Integer;

  Procedure CreateListToProcess;
  var
    I : Integer;
  begin
    If SelectFromLB.Items.Count <= 0 then
      exit;

    For I := 0 to SelectFromLB.Items.Count-1 do
    begin
      if SelectFromLB.Selected[I] then
      begin
        If CheckBoxAltStructOnly.Checked then
        begin
          if ListBoxMissing.Items.IndexOf(SelectFromLB.items.strings[I]) = -1 then
          { this adds the qualified item to the temp list }
            aList.Add(SelectFromLB.items.strings[I]);
        end
        else
        begin
          { this adds the qualified item to the temp list }
          aList.Add(SelectFromLB.items.strings[I]);
        end;
      end;
      {Record the fact that it was selected in the objects property}
      SelectFromLB.Items.Objects[I] := TObject(Ord(SelectFromLB.Selected[I]));
    end;{For}
    SelectFromLB.MultiSelect := False;
  end;

  Procedure ProcessList;
  var
    I : Integer;
  begin
    If aList.Count <= 0 then
      exit;
    For I := 0 to aList.Count-1 do
    begin
      try
        SelectFromLB.ItemIndex := SelectFromLB.Items.IndexOf(aList.Strings[I]);
        AssignBatchRec(TUtilityVerReb, aList, I);
        UpdateStats(TUtilityVerReb, aList);
        TUtilityVerReb.ExecuteVerifyRebuild;
      except
        {report the error to the log  so it doesn't stop the process}
        on E:Exception do
          SendToLog(E.Message);
      end;
      try
        ZeroGages;
      except
      { report the error to the log  so it doesn't stop the process}
        on E:Exception do
          SendToLog(E.Message);
      end;
    end;
    SelectFromLB.ItemIndex := -1;
    ChangeListFocus(LBNone);
  end;


Begin
  If CheckBoxAltStructOnly.Checked and
     (ComboBoxBorrowAlias.ItemIndex = -1) then
  begin
    Application.MessageBox('You must select an Database Alias to borrow the structure from.',
               '"Always Borrow Structure" Checked',
                MB_ICONHAND OR MB_OK);
    ComboBoxBorrowAlias.SetFocus;
    exit;
  end;
  ListBoxStatus.Setfocus;
  CurProcess := TURebuilding;
  GroupBoxVerify.Font.Color := clRed;
  aList := TStringList.Create;
  Try
    ZeroGages;
    TablesProcessed := 0;
    CreateListToProcess;
    ProcessList;
  finally
    sysutils.deletefile(TUtilityVerReb.tErrTableName);
    { reselect the originally selected items }
    SelectFromLB.MultiSelect := True;
    For I := 0 to SelectFromLB.Items.Count-1 do
      SelectFromLB.Selected[I] := Boolean(SelectFromLB.items.Objects[I]);
    aList.Free;
  end;
end;

procedure TRepairForm.TUtilityVerRebInfoRebuild(Sender: TObject;
  RebuildCBRec: TRebuildCBData);
begin
  with RebuildCBRec do
  begin
    if sMsg = '' then
    begin
      GaugeRebuild.Progress := iPercentDone;
    end
    else
    begin
      LabelNumPacked.Caption := sMsg;
      LabelNumPacked.refresh;
    end;
  end;
end;

procedure TRepairForm.TUtilityVerRebInfoVerify(Sender: TObject;
  VerifyCBRec: TVerifyCBData);
begin
  with VerifyCBRec do
  begin
    Case Process of
      TUVerifyTableName :;
      TUVerifyHeader    : GaugeHeader.Progress := PercentDone;
      TUVerifyIndex     : GaugeIndex.Progress := PercentDone;
      TUVerifyData      : GaugeData.Progress := PercentDone;
      TUVerifySXHeader  : GaugeHeaderIdx.Progress := PercentDone;
      TUVerifySXIndex   : GaugeIndexIdx.Progress := PercentDone;
      TUVerifySXData    : GaugeDataIdx.Progress := PercentDone;
      TUVerifySXIntegrity :   {the index count and current index is passed by the TUVerifySXIntegrity Process}
        begin
          GaugeIntegrity.Progress := PercentDone;
          LabelZeroOf.Caption := IntToStr(CurrentIndex);
          LabelOfZero.Caption := IntToStr(TotalIndex);
          LabelZeroOf.refresh;
          LabelOfZero.refresh;
        end;
    end; {Case}
  end;
end;

procedure TRepairForm.TUtilityRestInfoVerReb(Sender: TObject;
  AMessage: String; Process: TUVerRebProcess; var Abort: Boolean);
begin
  SendToLog(AMessage);
  { use process to highlight the active panel in the status dialog }
  if process <> CurProcess then
  begin
    Case Process of
    TUVerifying  :
      begin
        GroupBoxVerify.Font.Color := clRed;
        GroupBoxRebuild.Font.Color := clBlack;
      end;
    TURebuilding :
      begin
        GroupBoxVerify.Font.Color := clBlack;
        GroupBoxRebuild.Font.Color := clRed;
      end;
    end; {case}
    GroupBoxVerify.refresh;
    GroupBoxRebuild.refresh;
    CurProcess := Process;
  end;
end;

procedure TRepairForm.ButtonCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TRepairForm.ButtonVerifyOnlyClick(Sender: TObject);
var
  aList : TStringList;
  I : Integer;

  Procedure CreateListToProcess;
  var
    I : Integer;
  begin
    If SelectFromLB.Items.Count <= 0 then
      exit;
    For I := 0 to SelectFromLB.Items.Count-1 do
    begin
      if SelectFromLB.Selected[I] then
          aList.Add(SelectFromLB.items.strings[I]);
      {Record the fact that it was selected in the objects property}
      SelectFromLB.Items.Objects[I] := TObject(Ord(SelectFromLB.Selected[I]));
    end;{For}
    SelectFromLB.MultiSelect := False;
  end;


  Procedure ProcessList;
  var
    I : word;
  begin
    If aList.Count <= 0 then exit;
    For I := 0 to aList.Count-1 do
    begin
      try
        SelectFromLB.ItemIndex := SelectFromLB.Items.IndexOf(aList.Strings[I]);
        SendToLog('Verifying Table           :' + aList.Strings[I]);
        AssignBatchRec(TUtilityVerReb, aList, I);
        UpdateStats(TUtilityVerReb, aList);
        TUtilityVerReb.ExecuteVerify;
        SendToLog('Verifying Status          : ' +
           IntToStr(TUtilityVerReb.iErrorLevel));
      except
        {report the error to the log  so it doesn't stop the process}
        on E:Exception do
          SendToLog(E.Message);
      end;
      try
        ZeroGages;
        {now append all errors to the verify only error toble for reporting}
        if fileexists(TUtilityVerReb.tErrTableName) then
          TUtilityVerReb.Options := [vTU_Append_Errors];
      except
      { report the error to the log  so it doesn't stop the process}
        on E:Exception do
          SendToLog(E.Message);
      end;
    end;
    SelectFromLB.ItemIndex := -1;
    ChangeListFocus(LBNone);
  end;

begin
  ListBoxStatus.Setfocus;
  CurProcess := TUVerifying;
  GroupBoxVerify.Font.Color := clRed;
  TablesProcessed := 0;
  aList := TStringList.Create;
  Try
    ZeroGages;
    SendToLog('STARTING VERIFY ONLY PROCESSING OF THE BATCH');
    TUtilityVerReb.Options := [];
    CreateListToProcess;
    ProcessList;
    ChangeListFocus(LBNone);
  finally
    SendToLog('VERIFY ONLY PROCESSING - COMPLETE');
    { reselect the originally selected items }
    SelectFromLB.MultiSelect := True;
    For I := 0 to SelectFromLB.Items.Count-1 do
      SelectFromLB.Selected[I] := Boolean(SelectFromLB.items.Objects[I]);
    aList.Free;
  end;
end;

procedure TRepairForm.ButtonSaveLogClick(Sender: TObject);
begin
   if SaveDialogActivityLog.Execute then
   begin
     ListBoxStatus.Items.SaveToFile(SaveDialogActivityLog.FileName);
     if MessageDlg('Do you want to clear the message log?', mtConfirmation,
        [mbYes, mbNo], 0) = mrYes then
        ListBoxStatus.Items.Clear;
   end;
end;


procedure TRepairForm.SortList(aList : TStrings);
var
  TmpStr : String;
  I, S, Dest : Integer;
begin
  Dest := aList.Count - 1;
  While Dest > 0 do
  begin
    S := 0;
    { Find the highest value in column 1 that hasn't been sorted yet}
    For I := 0 to Dest do
    begin
      if AnsiCompareText(aList.Strings[S], aList.Strings[I])< 0 then
         S := I;
    end;
    { Now move the highest value into the destination, destination goes where source was}
    If S <> Dest then
    begin
      TmpStr := aList.Strings[S];
      aList.Strings[S] := alist.Strings[Dest];
      alist.Strings[Dest] := TmpStr;
    end;
    Dec(Dest);
  end;
end;

procedure TRepairForm.ButtonViewErrTableClick(Sender: TObject);
var
  ErrDlg : TForm;
  OKBtn: TBitBtn;
  PanelRed: TPanel;
  DBGridViewErr: TDBGrid;
begin
  {Hand make Error Form so no DFM no additional DFM is needed}
  TableErrTable.Active := False;
  TableErrTable.DatabaseName := Session.PrivateDir;
  ErrDlg := TForm.Create(Application);
  Try
    {Create the shell form and set its properties }
    ErrDlg.BorderIcons := [biSystemMenu,biMinimize,biMaximize];
    ErrDlg.BorderStyle := bsDialog;
    ErrDlg.Caption := 'Verify Report';
    ErrDlg.ClientHeight := 322;
    ErrDlg.ClientWidth := 488;
    ErrDlg.Height := 355;
    ErrDlg.Position := poScreenCenter;
    ErrDlg.Scaled := True;
    ErrDlg.Width := 496;
    {Add the OK button an set its properties}
    OKBtn := TBitBtn.Create(Nil);
    ErrDlg.InsertComponent(OKBtn);
    ErrDlg.InsertControl(OKBtn);
    OKBtn.Left      := 194;
    OKBtn.Top       := 284;
    OKBtn.Width     := 77;
    OKBtn.Height    := 27;
    OKBtn.Caption   := 'Close';
    OKBtn.TabOrder  := 0;
    OKBtn.Kind      := bkOK;
    OKBtn.Margin    := 2;
    OKBtn.Spacing   := -1;
    {Add the Red Panel an set its properties}
    PanelRed := TPanel.Create(Nil);
    ErrDlg.InsertComponent(PanelRed);
    ErrDlg.InsertControl(PanelRed);
    PanelRed.Left := 4;
    PanelRed.Top := 8;
    PanelRed.Width := 481;
    PanelRed.Height := 269;
    PanelRed.BevelOuter := bvNone;
    PanelRed.Color := clRed;
    PanelRed.Ctl3D := False;
    PanelRed.ParentCtl3D := False;
    PanelRed.TabOrder := 1;
    {Add the DBGrid an set its properties}
    DBGridViewErr := TDBGrid.Create(Nil);
    PanelRed.InsertComponent(DBGridViewErr);
    PanelRed.InsertControl(DBGridViewErr);
    DBGridViewErr.Left := 5;
    DBGridViewErr.Top := 5;
    DBGridViewErr.Width := 469;
    DBGridViewErr.Height := 259;
    DBGridViewErr.FixedColor := clRed;
    DBGridViewErr.Options := [dgTitles, dgColumnResize, dgColLines,
                             dgRowLines, dgTabs, dgConfirmDelete,
                             dgCancelOnExit, TDBGridOption(25)];
    DBGridViewErr.ReadOnly := True;
    DBGridViewErr.TabOrder := 0;
    DBGridViewErr.TitleFont.Color := clBlack;
    DBGridViewErr.TitleFont.Height := -11;
    DBGridViewErr.TitleFont.Name := 'MS Sans Serif';
    DBGridViewErr.TitleFont.Style := [fsBold];
    try
      TableErrTable.Active := True;
      ErrDlg.ActiveControl := OKBtn;
      DBGridViewErr.DataSource := DataSource1;
      ErrDlg.ShowModal;
      { Deactivate Error Table }
      TableErrTable.Active := False;
    except
      on E:EDBEngineError {10024} do
      if E.errors[0].errorcode = 10024 then
        MessageDlg('No error table exists.', mtInformation, [mbOK], 0);
      else
        raise;
    end;
  Finally
    ErrDlg.Release;
    ErrDlg := nil;
  end;
end;


function TRepairForm.GetAliasPath(TheAlias : String) : String;
var
  StrList : TStringList;
  I : Word;
begin
  result := '';
  if TheAlias = '' then exit;
  StrList := TStringList.Create;
  Session.GetAliasParams(TheAlias, StrList);
  For I := 0 to StrList.count-1 do
    if pos('PATH=',StrList.Strings[I]) = 1 then
    begin
      result := copy(StrList.Strings[I], 6, 128);
      break;
    end;

  StrList.Free;
end;

Procedure TRepairForm.ReFillSelectFromLB;
begin
  Session.GetTableNames(fTblAlias, fEditFilePattern,
                         True, False, SelectFromLB.Items);
  SortList(SelectFromLB.Items);
  ListBoxMissing.Clear;
end;

procedure TRepairForm.ComboBoxTblAliasChange(Sender: TObject);
begin
  with ComboBoxTblAlias do
  begin
    fTblAlias := Items.Strings[ItemIndex];
    ReFillSelectFromLB;
    AliasPath := GetAliasPath(Items.Strings[ItemIndex]);
  end;
  ChangeListFocus(LBNone);
end;

procedure TRepairForm.ComboBoxBorrowAliasChange(Sender: TObject);
begin
  if ComboBoxBorrowAlias.ItemIndex <> -1 then
  begin
    fAltTblAlias :=  ComboBoxBorrowAlias.Items.Strings[ComboBoxBorrowAlias.ItemIndex];
    ReFillSelectFromLB;
    ChangeListFocus(LBNone);
  end;
end;

procedure TRepairForm.ReDoBorrowList;
var
  BorrowAliasTbls : TStringList;
  I : Word;
begin
  ListBoxMissing.Clear;
  if SelectFromLB.items.count = 0 then exit;
  {Create a place to put the list of tables in the borrow alias}
  BorrowAliasTbls := TStringList.Create;
  Try
    {Fill the temp list with the files in the Borrow from alias}
    Session.GetTableNames(fAltTblAlias, fEditFilePattern,
      True, False, BorrowAliasTbls);
    {Find all the tables in the table List that are not also
     in the Borrow from list and add them to the missing list}
    For I := 0 to SelectFromLB.Items.Count - 1 do
      if SelectFromLB.Selected[I] and
           (BorrowAliasTbls.IndexOf(SelectFromLB.Items.Strings[I]) = -1) then
        ListBoxMissing.Items.Add(SelectFromLB.Items.Strings[I]);
    {Get the complete path to the Borrow from alias directory}
    AltPath := GetAliasPath(ComboBoxBorrowAlias.Items.Strings[ComboBoxBorrowAlias.ItemIndex]);
  finally
    BorrowAliasTbls.Free;
  end;
end;

procedure TRepairForm.butRebuildClick(Sender: TObject);
begin
 TUtilityVerReb.AlwaysRebuild := True;
 Try
  ButtonFixAllClick(Sender);
 Finally
  TUtilityVerReb.AlwaysRebuild := False;
 end;
end;

procedure TRepairForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  DeleteErrorTable;
end;


procedure TRepairForm.ChangeListFocus(FocusList : TListFocus);
  procedure UpdateTableInfo(whichList : TListBox);
  begin
     AssignBatchRec(TUtilityVerReb, whichList.Items, whichList.ItemIndex);
     UpdateStats(TUtilityVerReb, Nil);
  end;
begin
  if FListFocus <> FocusList then
    case fListFocus of
      LBSelectFrom : SelectFromLB.ItemIndex := -1;
      LBMissing    : ListBoxMissing.ItemIndex := -1;
      LBNone :;
    end; {case}
  fListFocus := FocusList;
  case fListFocus of
    LBSelectFrom : UpdateTableInfo(SelectFromLB);
    LBMissing    : UpdateTableInfo(ListBoxMissing);
    LBNone       : UpdateStats(Nil, Nil);
  end; {case}
end;


procedure TRepairForm.SelectFromLBClick(Sender: TObject);
begin
  ChangeListFocus(LBSelectFrom);
  SortList(ListBoxMissing.Items);
  SortList(SelectFromLB.Items);
  ReDoBorrowList;
end;

procedure TRepairForm.ListBoxMissingClick(Sender: TObject);
begin
  ChangeListFocus(LBMissing);
end;

procedure TRepairForm.SpeedButtonAllClick(Sender: TObject);
var
  I : Integer;
begin
  For I := 0 to (SelectFromLB.Items.Count-1) do
    SelectFromLB.Selected[I] := True;
  if fListFocus = LBSelectFrom then
     ChangeListFocus(LBNone);
 ReDoBorrowList;
end;

procedure TRepairForm.SpeedButtonAllNoneClick(Sender: TObject);
var
  I : Integer;
begin
  SelectFromLB.Clear;
  ReFillSelectFromLB;
  For I := 0 to (SelectFromLB.Items.Count-1) do
  begin
    SelectFromLB.Selected[I] := False;
  end;
  ChangeListFocus(LBNone);
end;

end.



